// file: lmsw64dp_verbose_1.c
// Verbose Listing for 64 Bit Detector-Pair Packets

// 9-Oct-2012 wfj

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <stdlib.h>
#include <iostream.h>

FILE *streami;

main (int argc, char **argv)
{

	static __int64 i,j;
	static __int64 i64_i1;

	static char *in_file;

	static int qb;
	static int ax, bx, xe, ay, by, tof, prompt;
	static unsigned int ew1, ew2;
	static int sync;
	static int tag;

	static int ms;		// milliseconds
	static int hbp;		// horizontal bed position value
	static int hbp_se;	// sign-extended horiz. bed position value
	static int lost;	// lost event tally value
	static int tof_se;	// sign-extended tof value

  // get a filename from the command line

	if (argc < 1)	{
		printf ("usage: %s in_file_name\n",argv[0]);
		exit(1);
    }
	else	{ in_file = argv[1];}

 	streami = fopen (in_file, "rb");
	if ( streami == NULL) {
		printf ("No file opened %s\n",in_file);
		exit (1);
		}

	i64_i1 = 0; 
		
	while  ((i = fread (&ew1, sizeof(qb), 1, streami) ) != 0) {
		
		if ((j = fread (&ew2, sizeof(qb), 1, streami) ) != 0) {

		sync = (!((ew1>>31) & 1)) && ((ew2>>31) & 1);
		
		if (!sync) { 
			printf(" PACKET SYNC ERROR 64_bit_word_cnt: %I64d ew1 ew2: %x %x\n",i64_i1,ew1,ew2);
			exit (1);
			}
		
		if (sync) {

			i64_i1 = i64_i1 + 1;

			tag = ((ew1>>28)&0x4)!=0;

			ax = bx = xe = ay = by = tof = prompt = 0;

			if(!tag) {
				ax =   ew1 & 0xff; 
				bx =   ew2 & 0xff;
				xe = ((ew1>>16)  & 7) | (((ew2>>16) & 7)<<3);
				ay =  (ew1>>8)   & 0xff;
				by =  (ew2>>8)   & 0xff;
				tof = ((ew1>>25) & 7) | (((ew2>>25) & 7) << 3);
				tof_se = tof;
				if (((tof >> 5) & 1) == 1) tof_se = tof | 0xffffffc0;
				prompt = (ew2>>30) & 1;
			
				printf(" EVENT: pkt_cnt: %I64d ew2 ew1(h): %8x %8x ax bx: %3d %3d xe %2d ay by: %3d %3d tof(h): %2x tof_se(d): %3d prompt: %1d\n",
							    i64_i1,		   ew2,ew1,			   ax,bx,		  xe,	 ay,by,         tof,        tof_se,        prompt);
			}

			if ( tag){
				if ( ((ew2 >> 12) & 0xe ) == 0x8 ) { // Elapsed Time Tag Packet
					ms = ( ((ew2 & 0x1fff)<<16) | (ew1 & 0xffff) ); // Extract 29-bit millisecond field
					printf(" TAG64_ElapsedTime:    pkt_cnt: %I64d ew2 ew1(h): %8x %8x ms(h): %7x ms(d): %9d\n",
												   i64_i1,		  ew2,ew1,            ms,        ms);
				}
				if ( ((ew2 >>  8) & 0xff) == 0xc4) { // Horizontal Bed Position Tag Packet
					hbp = ( ((ew2 & 0xff)<<16) | (ew1 & 0xffff) ); // Extract 20-bit bed position field
					hbp_se = hbp; // Assume hbp is Zero
					if (((hbp >> 19) & 1) == 1) hbp_se = hbp | 0xfff00000; // Need to Sign Extend
					printf(" TAG64_HorizBedPos:    pkt_cnt: %I64d ew2 ew1(h): %8x %8x hbp(h):   %6x hbp_se(d): %8d\n",
												   i64_i1,		  ew2,ew1,            hbp,        hbp_se);
				}
				if ( ((ew2 >>  8) & 0xfc) == 0xbc) { // Lost Event Tally Tag Packet - Type 7 (GIM)
					lost = ( ((ew2 & 0xff)<<16) | (ew1 & 0xffff) ); // Extract 20-bit lost tally field
					printf(" TAG64_LostEventTally: pkt_cnt: %I64d ew2 ew1(h): %8x %8x lost(d): %7d\n",
												   i64_i1,		  ew2,ew1,            lost);
				}

			}
		}
	  }
	}

	fclose (streami);

	exit(0);
}