//file: ml_ea4r_64dp_walkthrough_1.c
// make list-mode file - software list mode generator 
// Eagle 4-Ring 64-bit detector-pair packet field walkthrough
// 8-Oct-2012 wfj 

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <stdlib.h>
#include <iostream.h>

FILE *streamt;

main (int argc, char **argv)
{

	static int i,j;
	static int e1, e2;
	static int b1, b2;
	static int let1, let2;
	static unsigned __int64 i1;

	static char *out_file;

	static int qb;
	static int ax, bx;	// 0 to 51
	static int ay, by;	// 0 to 51 for 4 rings
	static int xe;		// 1 to 54
	static int prompt;	// 0 to 1
	static int tof;		// -24 to 27
	static unsigned int ew1, ew2;
	static unsigned int ms = 0;		// milliseconds
	static int hbp = 0;			// horizontal bed position
	static unsigned int lost = 0;	// lost event tally quantity

  // get a filename from the command line
    if (argc < 2)
     {
       printf ("usage: %s out_file_name\n",argv[0]);
       exit(1);
     }
    else	out_file = argv[1];

 	streamt = fopen (out_file, "wb");
	if ( streamt == NULL) {
		printf ("No file opened %s\n",out_file);
		exit (1);
		}

// Load Output File
	
// Incrementing Elapased Time Tag Packet
	e1 = 0x40000000 |  (ms          & 0xffff);
	e2 = 0x80008000 | ((ms++ >> 16) & 0x3fff);
	j = fwrite (&e1, sizeof(qb), 1, streamt);
	j = fwrite (&e2, sizeof(qb), 1, streamt);

// Decrementing Horizontal Bed Position Tag Packet
	b1 = 0x40000000 |  (hbp          & 0xffff);
	b2 = 0x8000c400 | ((hbp-- >> 16) & 0xf);
	j = fwrite (&b1, sizeof(qb), 1, streamt);
	j = fwrite (&b2, sizeof(qb), 1, streamt);

// Incrementing Lost Event Tally Tag Packet - Type 7 (GIM) & NonFunctional as a Loss Tally
	let1 = 0x40000000 |  (lost          & 0xffff);
	let2 = 0x8000bc00 | ((lost++ >> 16) & 0xf);
	j = fwrite (&let1, sizeof(qb), 1, streamt);
	j = fwrite (&let2, sizeof(qb), 1, streamt);

// Packets to Step through ax Field
	ax = 0; bx = 0; xe = 1;	ay = 0; by = 0; prompt = 1; tof = 0; 
	for (ax=0; ax <= 51; ax++) {	
		ew1 = ax | (ay<<8) | ((xe&0x7)<<16) | ((tof & 0x7)<<25);
		ew2 = bx | (by<<8) | ((xe>>3)<<16)  | (((tof >> 3)  & 0x7)<<25) | ((prompt&1)<<30) | (1<<31);
		j = fwrite (&ew1, sizeof(qb), 1, streamt);
		j = fwrite (&ew2, sizeof(qb), 1, streamt);
		i1 = i1 + 1;
	 }

// Incrementing Elapased Time Tag Packet
	e1 = 0x40000000 |  (ms          & 0xffff);
	e2 = 0x80008000 | ((ms++ >> 16) & 0x3fff);
	j = fwrite (&e1, sizeof(qb), 1, streamt);
	j = fwrite (&e2, sizeof(qb), 1, streamt);

// Decrementing Horizontal Bed Position Tag Packet
	b1 = 0x40000000 |  (hbp          & 0xffff);
	b2 = 0x8000c400 | ((hbp-- >> 16) & 0xf);
	j = fwrite (&b1, sizeof(qb), 1, streamt);
	j = fwrite (&b2, sizeof(qb), 1, streamt);

// Incrementing Lost Event Tally Tag Packet - Type 7 (GIM) & NonFunctional as a Loss Tally
	let1 = 0x40000000 |  (lost          & 0xffff);
	let2 = 0x8000bc00 | ((lost++ >> 16) & 0xf);
	j = fwrite (&let1, sizeof(qb), 1, streamt);
	j = fwrite (&let2, sizeof(qb), 1, streamt);

// Packets to Step through bx Field
	ax = 0; bx = 0; xe = 1;	ay = 0; by = 0; prompt = 1; tof = 0; 
	for (bx=0; bx <= 51; bx++) {	
		ew1 = ax | (ay<<8) | ((xe&0x7)<<16) | ((tof & 0x7)<<25);
		ew2 = bx | (by<<8) | ((xe>>3)<<16)  | (((tof >> 3)  & 0x7)<<25) | ((prompt&1)<<30) | (1<<31);
		j = fwrite (&ew1, sizeof(qb), 1, streamt);
		j = fwrite (&ew2, sizeof(qb), 1, streamt);
		i1 = i1 + 1;
	 }

// Incrementing Elapased Time Tag Packet
	e1 = 0x40000000 |  (ms          & 0xffff);
	e2 = 0x80008000 | ((ms++ >> 16) & 0x3fff);
	j = fwrite (&e1, sizeof(qb), 1, streamt);
	j = fwrite (&e2, sizeof(qb), 1, streamt);

// Decrementing Horizontal Bed Position Tag Packet
	b1 = 0x40000000 |  (hbp          & 0xffff);
	b2 = 0x8000c400 | ((hbp-- >> 16) & 0xf);
	j = fwrite (&b1, sizeof(qb), 1, streamt);
	j = fwrite (&b2, sizeof(qb), 1, streamt);

// Incrementing Lost Event Tally Tag Packet - Type 7 (GIM) & NonFunctional as a Loss Tally
	let1 = 0x40000000 |  (lost          & 0xffff);
	let2 = 0x8000bc00 | ((lost++ >> 16) & 0xf);
	j = fwrite (&let1, sizeof(qb), 1, streamt);
	j = fwrite (&let2, sizeof(qb), 1, streamt);

// Packets to Step through xe Field
	ax = 0; bx = 0; xe = 1;	ay = 0; by = 0; prompt = 1; tof = 0; 
	for (xe=1; xe <= 54; xe++) {	
		ew1 = ax | (ay<<8) | ((xe&0x7)<<16) | ((tof & 0x7)<<25);
		ew2 = bx | (by<<8) | ((xe>>3)<<16)  | (((tof >> 3)  & 0x7)<<25) | ((prompt&1)<<30) | (1<<31);
		j = fwrite (&ew1, sizeof(qb), 1, streamt);
		j = fwrite (&ew2, sizeof(qb), 1, streamt);
		i1 = i1 + 1;
	 }

// Incrementing Elapased Time Tag Packet
	e1 = 0x40000000 |  (ms          & 0xffff);
	e2 = 0x80008000 | ((ms++ >> 16) & 0x3fff);
	j = fwrite (&e1, sizeof(qb), 1, streamt);
	j = fwrite (&e2, sizeof(qb), 1, streamt);

// Decrementing Horizontal Bed Position Tag Packet
	b1 = 0x40000000 |  (hbp          & 0xffff);
	b2 = 0x8000c400 | ((hbp-- >> 16) & 0xf);
	j = fwrite (&b1, sizeof(qb), 1, streamt);
	j = fwrite (&b2, sizeof(qb), 1, streamt);

// Incrementing Lost Event Tally Tag Packet - Type 7 (GIM) & NonFunctional as a Loss Tally
	let1 = 0x40000000 |  (lost          & 0xffff);
	let2 = 0x8000bc00 | ((lost++ >> 16) & 0xf);
	j = fwrite (&let1, sizeof(qb), 1, streamt);
	j = fwrite (&let2, sizeof(qb), 1, streamt);

// Packets to Step through ay Field
	ax = 0; bx = 0; xe = 1;	ay = 0; by = 0; prompt = 1; tof = 0; 
	for (ay=0; ay <= 51; ay++) {	
		ew1 = ax | (ay<<8) | ((xe&0x7)<<16) | ((tof & 0x7)<<25);
		ew2 = bx | (by<<8) | ((xe>>3)<<16)  | (((tof >> 3)  & 0x7)<<25) | ((prompt&1)<<30) | (1<<31);
		j = fwrite (&ew1, sizeof(qb), 1, streamt);
		j = fwrite (&ew2, sizeof(qb), 1, streamt);
		i1 = i1 + 1;
	 }

// Incrementing Elapased Time Tag Packet
	e1 = 0x40000000 |  (ms          & 0xffff);
	e2 = 0x80008000 | ((ms++ >> 16) & 0x3fff);
	j = fwrite (&e1, sizeof(qb), 1, streamt);
	j = fwrite (&e2, sizeof(qb), 1, streamt);

// Decrementing Horizontal Bed Position Tag Packet
	b1 = 0x40000000 |  (hbp          & 0xffff);
	b2 = 0x8000c400 | ((hbp-- >> 16) & 0xf);
	j = fwrite (&b1, sizeof(qb), 1, streamt);
	j = fwrite (&b2, sizeof(qb), 1, streamt);

// Incrementing Lost Event Tally Tag Packet - Type 7 (GIM) & NonFunctional as a Loss Tally
	let1 = 0x40000000 |  (lost          & 0xffff);
	let2 = 0x8000bc00 | ((lost++ >> 16) & 0xf);
	j = fwrite (&let1, sizeof(qb), 1, streamt);
	j = fwrite (&let2, sizeof(qb), 1, streamt);

// Packets to Step through by Field
	ax = 0; bx = 0; xe = 1;	ay = 0; by = 0; prompt = 1; tof = 0; 
	for (by=0; by <= 51; by++) {	
		ew1 = ax | (ay<<8) | ((xe&0x7)<<16) | ((tof & 0x7)<<25);
		ew2 = bx | (by<<8) | ((xe>>3)<<16)  | (((tof >> 3)  & 0x7)<<25) | ((prompt&1)<<30) | (1<<31);
		j = fwrite (&ew1, sizeof(qb), 1, streamt);
		j = fwrite (&ew2, sizeof(qb), 1, streamt);
		i1 = i1 + 1;
	 }

// Incrementing Elapased Time Tag Packet
	e1 = 0x40000000 |  (ms          & 0xffff);
	e2 = 0x80008000 | ((ms++ >> 16) & 0x3fff);
	j = fwrite (&e1, sizeof(qb), 1, streamt);
	j = fwrite (&e2, sizeof(qb), 1, streamt);

// Decrementing Horizontal Bed Position Tag Packet
	b1 = 0x40000000 |  (hbp          & 0xffff);
	b2 = 0x8000c400 | ((hbp-- >> 16) & 0xf);
	j = fwrite (&b1, sizeof(qb), 1, streamt);
	j = fwrite (&b2, sizeof(qb), 1, streamt);

// Incrementing Lost Event Tally Tag Packet - Type 7 (GIM) & NonFunctional as a Loss Tally
	let1 = 0x40000000 |  (lost          & 0xffff);
	let2 = 0x8000bc00 | ((lost++ >> 16) & 0xf);
	j = fwrite (&let1, sizeof(qb), 1, streamt);
	j = fwrite (&let2, sizeof(qb), 1, streamt);

// Packets to Step through tof Field
	ax = 0; bx = 0; xe = 1;	ay = 0; by = 0; prompt = 1; tof = 0; 
	for (tof=-24; tof <= 27; tof++) {	
		ew1 = ax | (ay<<8) | ((xe&0x7)<<16) | ((tof & 0x7)<<25);
		ew2 = bx | (by<<8) | ((xe>>3)<<16)  | (((tof >> 3)  & 0x7)<<25) | ((prompt&1)<<30) | (1<<31);
		j = fwrite (&ew1, sizeof(qb), 1, streamt);
		j = fwrite (&ew2, sizeof(qb), 1, streamt);
		i1 = i1 + 1;
	 }

// Incrementing Elapased Time Tag Packet
	e1 = 0x40000000 |  (ms          & 0xffff);
	e2 = 0x80008000 | ((ms++ >> 16) & 0x3fff);
	j = fwrite (&e1, sizeof(qb), 1, streamt);
	j = fwrite (&e2, sizeof(qb), 1, streamt);

// Decrementing Horizontal Bed Position Tag Packet
	b1 = 0x40000000 |  (hbp          & 0xffff);
	b2 = 0x8000c400 | ((hbp-- >> 16) & 0xf);
	j = fwrite (&b1, sizeof(qb), 1, streamt);
	j = fwrite (&b2, sizeof(qb), 1, streamt);

// Incrementing Lost Event Tally Tag Packet - Type 7 (GIM) & NonFunctional as a Loss Tally
	let1 = 0x40000000 |  (lost          & 0xffff);
	let2 = 0x8000bc00 | ((lost++ >> 16) & 0xf);
	j = fwrite (&let1, sizeof(qb), 1, streamt);
	j = fwrite (&let2, sizeof(qb), 1, streamt);

// Example of One Delayed & One Prompt Events
	ax = 0; bx = 0; xe = 1;	ay = 0; by = 0; prompt = 1; tof = 0; 
	for (prompt=0; prompt <= 1; prompt++) {	
		ew1 = ax | (ay<<8) | ((xe&0x7)<<16) | ((tof & 0x7)<<25);
		ew2 = bx | (by<<8) | ((xe>>3)<<16)  | (((tof >> 3)  & 0x7)<<25) | ((prompt&1)<<30) | (1<<31);
		j = fwrite (&ew1, sizeof(qb), 1, streamt);
		j = fwrite (&ew2, sizeof(qb), 1, streamt);
		i1 = i1 + 1;
	 }

// Maximum Value for Elapased Time Tag Packet
	ms = 0x1fffffff; // all bits in 29-bit field set to one
	e1 = 0x40000000 |  (ms          & 0xffff);
	e2 = 0x80008000 | ((ms   >> 16) & 0x3fff);
	j = fwrite (&e1, sizeof(qb), 1, streamt);
	j = fwrite (&e2, sizeof(qb), 1, streamt);

// Minimum Value (most negative) Horizontal Bed Position Tag Packet
	hbp = 0x80000; 
	b1 = 0x40000000 |  (hbp          & 0xffff);
	b2 = 0x8000c400 | ((hbp   >> 16) & 0xf);
	j = fwrite (&b1, sizeof(qb), 1, streamt);
	j = fwrite (&b2, sizeof(qb), 1, streamt);

// Maximum Value Lost Event Tally Tag Packet - Type 7 (GIM) & NonFunctional as a Loss Tally
	lost = 0xfffff; // all bits in 20-bit field set to one
	let1 = 0x40000000 |  (lost          & 0xffff);
	let2 = 0x8000bc00 | ((lost   >> 16) & 0xf);
	j = fwrite (&let1, sizeof(qb), 1, streamt);
	j = fwrite (&let2, sizeof(qb), 1, streamt);

	printf (" number of 64-bit packets output: %I64d file size: %I64x\n",i1,8*i1);
	fclose (streamt);
	exit(0);
}
