//file: ml_ea_64ba_walkthrough_1.c
// make list-mode file - software list mode generator 
// Eagle 64-bit bin-address packet field walkthrough
// 9-Oct-2012 wfj 

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <stdlib.h>
#include <iostream.h>

FILE *streamt;

main (int argc, char **argv)
{

	static int i,j;
	static int e1, e2;
	static int b1, b2;
	static int let1, let2;
	static unsigned __int64 i1;

	static char *out_file;

	static int qb;
	static int prompt;	// 0 to 1
	static unsigned int ew1, ew2;
	static unsigned int ms = 0;		// milliseconds
	static int hbp = 0;				// horizontal bed position
	static unsigned int lost = 0;	// lost event tally quantity
	static unsigned __int64 ba, bapkt;

  // get a filename from the command line
    if (argc < 2)
     {
       printf ("usage: %s out_file_name\n",argv[0]);
       exit(1);
     }
    else	out_file = argv[1];

 	streamt = fopen (out_file, "wb");
	if ( streamt == NULL) {
		printf ("No file opened %s\n",out_file);
		exit (1);
		}

// Load Output File
	
// Incrementing Elapased Time Tag Packet
	e1 = 0x40000000 |  (ms          & 0xffff);
	e2 = 0x80008000 | ((ms++ >> 16) & 0x3fff);
	j = fwrite (&e1, sizeof(qb), 1, streamt);
	j = fwrite (&e2, sizeof(qb), 1, streamt);

// Decrementing Horizontal Bed Position Tag Packet
	b1 = 0x40000000 |  (hbp          & 0xffff);
	b2 = 0x8000c400 | ((hbp-- >> 16) & 0xf);
	j = fwrite (&b1, sizeof(qb), 1, streamt);
	j = fwrite (&b2, sizeof(qb), 1, streamt);

// Incrementing Lost Event Tally Tag Packet - Type 7 (GIM) & NonFunctional as a Loss Tally
	let1 = 0x40000000 |  (lost          & 0xffff);
	let2 = 0x8000bc00 | ((lost++ >> 16) & 0xf);
	j = fwrite (&let1, sizeof(qb), 1, streamt);
	j = fwrite (&let2, sizeof(qb), 1, streamt);

// Packets to Step through ax Field
	ba = 0; prompt = 0;  
	for (ba=0; ba <= 0xf; ba++) {	
		bapkt =	0x8000000000000000 | 
				  (ba & 0xffff)             | (((ba >> 16) & 0xffff) << 32) |
				(((ba >> 32) & 0xf) << 16)	| (((ba >> 36) & 0xf) << 48)    |
				(((__int64)prompt) << 62);
		ew1 = (int)( bapkt        & 0xffffffff);
		ew2 = (int)((bapkt >> 32) & 0xffffffff);
		j = fwrite (&ew1, sizeof(qb), 1, streamt);
		j = fwrite (&ew2, sizeof(qb), 1, streamt);
		i1 = i1 + 1;
	 }

// Incrementing Elapased Time Tag Packet
	e1 = 0x40000000 |  (ms          & 0xffff);
	e2 = 0x80008000 | ((ms++ >> 16) & 0x3fff);
	j = fwrite (&e1, sizeof(qb), 1, streamt);
	j = fwrite (&e2, sizeof(qb), 1, streamt);

// Decrementing Horizontal Bed Position Tag Packet
	b1 = 0x40000000 |  (hbp          & 0xffff);
	b2 = 0x8000c400 | ((hbp-- >> 16) & 0xf);
	j = fwrite (&b1, sizeof(qb), 1, streamt);
	j = fwrite (&b2, sizeof(qb), 1, streamt);

// Incrementing Lost Event Tally Tag Packet - Type 7 (GIM) & NonFunctional as a Loss Tally
	let1 = 0x40000000 |  (lost          & 0xffff);
	let2 = 0x8000bc00 | ((lost++ >> 16) & 0xf);
	j = fwrite (&let1, sizeof(qb), 1, streamt);
	j = fwrite (&let2, sizeof(qb), 1, streamt);

// Packets to Increment Up to Maximum a Portion of the ba Field with Prompt bit set
	ba = 0; prompt = 1;  
	for (ba=0xfffffffff0; ba <= 0xffffffffff; ba++) {	
		bapkt =	0x8000000000000000 | 
				  (ba & 0xffff)             | (((ba >> 16) & 0xffff) << 32) |
				(((ba >> 32) & 0xf) << 16)	| (((ba >> 36) & 0xf) << 48)    |
				(((__int64)prompt) << 62);
		ew1 = (int)( bapkt        & 0xffffffff);
		ew2 = (int)((bapkt >> 32) & 0xffffffff);
		j = fwrite (&ew1, sizeof(qb), 1, streamt);
		j = fwrite (&ew2, sizeof(qb), 1, streamt);
		i1 = i1 + 1;
	 }

// Maximum Value for Elapased Time Tag Packet
	ms = 0x1fffffff; // all bits in 29-bit field set to one
	e1 = 0x40000000 |  (ms          & 0xffff);
	e2 = 0x80008000 | ((ms   >> 16) & 0x3fff);
	j = fwrite (&e1, sizeof(qb), 1, streamt);
	j = fwrite (&e2, sizeof(qb), 1, streamt);

// Minimum Value (most negative) Horizontal Bed Position Tag Packet
	hbp = 0x80000; 
	b1 = 0x40000000 |  (hbp          & 0xffff);
	b2 = 0x8000c400 | ((hbp   >> 16) & 0xf);
	j = fwrite (&b1, sizeof(qb), 1, streamt);
	j = fwrite (&b2, sizeof(qb), 1, streamt);

// Maximum Value Lost Event Tally Tag Packet - Type 7 (GIM) & NonFunctional as a Loss Tally
	lost = 0xfffff; // all bits in 20-bit field set to one
	let1 = 0x40000000 |  (lost          & 0xffff);
	let2 = 0x8000bc00 | ((lost   >> 16) & 0xf);
	j = fwrite (&let1, sizeof(qb), 1, streamt);
	j = fwrite (&let2, sizeof(qb), 1, streamt);


	printf (" number of 64-bit packets output: %I64d file size: %I64x\n",i1,8*i1);
	fclose (streamt);
	exit(0);
}
