// file: lmsw64dp_vision_verbose_3.c
// Verbose Listing for Vision 64-Bit Detector-Pair Packets

// 3-Jul-2018 wfj

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <stdlib.h>
#include <iostream.h>

FILE *streami;

main (int argc, char **argv)
{

	static __int64 i,j;
	static __int64 i64_i1;

	static char *in_file;

	static int qb;
	static unsigned int ax, bx;		// Pair of 6-bit transaxial detector index fields.
	static unsigned int xe;			// 8-bit Transaxial Encoding (Module Pair) field.
	static unsigned int ay, by;		// Pair of 7-bit axial (crystal ring) index fields.
	static unsigned int tof;		// 9-bit time-of-flight offset field. 
	static unsigned int ae, be;		// Pair of 8-bit gamma photon energy fields. 
									//		[Note: Perhaps only 6 bits active in each field.]
	static int prompt;				// Set to 1 if (non-tag) prompt event, to zero if (non-tag) delayed event.
	static unsigned int ew1, ew2;	// First and Second 32-bit words forming 64-bit packet.
	static int sync;				// Set to 1 only if stream indexing is in synchrony with packet sync bits.
	static int tag;					// Set to 1 if non-event "tag" packet, to zero if event packet. 

	static int ms;		// milliseconds
	static int hbp;		// horizontal bed position value
	static int hbp_se;	// sign-extended horiz. bed position value
	static int lost;	// lost event tally value
	static int tof_se;	// sign-extended tof value

  // get a filename from the command line

	if (argc < 2)	{
		printf ("usage: %s in_file_name\n",argv[0]);
		exit(1);
    }
	else	{ in_file = argv[1];}

 	streami = fopen (in_file, "rb");
	if ( streami == NULL) {
		printf ("No file opened %s\n",in_file);
		exit (1);
		}

	i64_i1 = 0; 
		
	while  ((i = fread (&ew1, sizeof(qb), 1, streami) ) != 0) {
		
		if ((j = fread (&ew2, sizeof(qb), 1, streami) ) != 0) {

		sync = (!((ew1>>31) & 1)) && ((ew2>>31) & 1);
		
		if (!sync) { 
			printf(" PACKET SYNC ERROR 64_bit_word_cnt: %I64d ew1 ew2: %x %x\n",i64_i1,ew1,ew2);
			exit (1);
			}
		
		if (sync) {

			i64_i1 = i64_i1 + 1;

			tag = ((ew1>>28)&0x4)!=0;

			ax = bx = xe = ay = by = ae = be = tof = prompt = 0;

			if(!tag) {
				ax =   ew1 & 0x3f; 
				bx =   ew2 & 0x3f;
				xe = ((ew1>>16)&7) | (((ew2>>16)&7)<<3) | (((ew1>>6)&1)<<6) | (((ew2>>6)&1)<<7) ;
				ay =  (ew1>>8) & 0x7f;
				by =  (ew2>>8) & 0x7f;
				ae =  ((ew1>>19)&0x3f) | (((ew1>>15)&1) << 6) | (((ew1>>7)&1) << 7);
				be =  ((ew2>>19)&0x3f) | (((ew2>>15)&1) << 6) | (((ew2>>7)&1) << 7);
				tof = ((ew1>>25)&7) | (((ew2>>25)&7)<<3) | (((ew1>>28)&1)<<6) | (((ew2>>28)&1)<<7) | (((ew1>>29)&1)<<8) ;
				tof_se = tof;
				if (((tof >> 8) & 1) == 1) tof_se = tof | 0xffffff00; //extend sign bit as needed.
				prompt = (ew2>>30) & 1;
			
				printf(" EVENT: pkt_cnt: %I64d ew2 ew1(h): %8x %8x ax bx: %2d %2d xe %3d ay by: %2d %2d ae,be: %3d %3d tof(h): %3x tof_se(d): %4d prompt: %1d\n",
							    i64_i1,		   ew2,ew1,			   ax,bx,		  xe,	 ay,by,         ae,be,         tof,        tof_se,        prompt);
			}

			if ( tag){
				if ( ((ew2 >> 12) & 0xe ) == 0x8 ) { // Elapsed Time Tag Packet
					ms = ( ((ew2 & 0x1fff)<<16) | (ew1 & 0xffff) ); // Extract 29-bit millisecond field
					printf(" TAG64_ElapsedTime:    pkt_cnt: %I64d ew2 ew1(h): %8x %8x ms(h): %7x ms(d): %9d\n",
												   i64_i1,		  ew2,ew1,            ms,        ms);
				}
				if ( ((ew2 >>  8) & 0xff) == 0xc4) { // Horizontal Bed Position Tag Packet
					hbp = ( ((ew2 & 0xff)<<16) | (ew1 & 0xffff) ); // Extract 20-bit bed position field
					hbp_se = hbp; // Assume hbp is Zero
					if (((hbp >> 19) & 1) == 1) hbp_se = hbp | 0xfff00000; // Need to Sign Extend
					printf(" TAG64_HorizBedPos:    pkt_cnt: %I64d ew2 ew1(h): %8x %8x hbp(h):   %6x hbp_se(d): %8d\n",
												   i64_i1,		  ew2,ew1,            hbp,        hbp_se);
				}
				if ( ((ew2 >>  8) & 0xfc) == 0xbc) { // Lost Event Tally Tag Packet - Type 7 (GIM)
					lost = ( ((ew2 & 0xff)<<16) | (ew1 & 0xffff) ); // Extract 20-bit lost tally field
					printf(" TAG64_LostEventTally: pkt_cnt: %I64d ew2 ew1(h): %8x %8x lost(d): %7d\n",
												   i64_i1,		  ew2,ew1,            lost);
				}

			}
		}
	  }
	}

	fclose (streami);

	exit(0);
}