//file: ml_vi8r_64dp_walkthrough_3.c
// make list-mode file - software list mode generator 
// Vision (Osprey 1) 8-Ring 64-bit detector-pair packet field walkthrough

// 3-Jul-2018 wfj 

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <stdlib.h>
#include <iostream.h>

FILE *streamt;

main (int argc, char **argv)
{

	static int i,j;
	static int e1, e2;		// First and Second 32-bit words forming 64-bit elapsed time tag packet.
	static int b1, b2;		// First and Second 32-bit words forming 64-bit horizontal bed position tag packet.
	static int let1, let2;	// First and Second 32-bit words forming 64-bit lost event tally tag packet.
	static unsigned __int64 i1;

	static char *out_file;

	static int qb;			// quad byte.

	static unsigned int ax, bx;		// Pair of 6-bit transaxial detector index fields. [0 to 39]
	static unsigned int xe;			// 8-bit Transaxial Encoding (Module Pair) field. [1 to 133]
	static unsigned int ay, by;		// Pair of 7-bit axial (crystal ring) index fields. [0 to 79, for 8-ring]
	static int tof;					// 2's Complement 9-bit time-of-flight offset field. [-256 to 255]
	static unsigned int ae, be;		// Pair of 8-bit gamma photon energy fields. [0 to 255]
									//		[Note: Perhaps only 6 bits active in each field.]
	static int prompt;				// Set to 1 if (non-tag) prompt event, to zero if (non-tag) delayed event.
	static unsigned int ew1, ew2;	// First and Second 32-bit words forming 64-bit packet.
	static int sync;				// Set to 1 only if stream indexing is in synchrony with packet sync bits.
	static int tag;					// Set to 1 if non-event "tag" packet, to zero if event packet. 
	
	static unsigned int ms = 0;		// milliseconds
	static int hbp = 0;				// horizontal bed position
	static unsigned int lost = 0;	// lost event tally quantity

  // get a filename from the command line
    if (argc < 2)
     {
       printf ("usage: %s out_file_name\n",argv[0]);
       exit(1);
     }
    else	out_file = argv[1];

 	streamt = fopen (out_file, "wb");
	if ( streamt == NULL) {
		printf ("No file opened %s\n",out_file);
		exit (1);
		}

// Load Output File
	
// Incrementing Elapased Time Tag Packet
	e1 = 0x40000000 |  (ms          & 0xffff);
	e2 = 0x80008000 | ((ms++ >> 16) & 0x3fff);
	j = fwrite (&e1, sizeof(qb), 1, streamt);
	j = fwrite (&e2, sizeof(qb), 1, streamt);

// Decrementing Horizontal Bed Position Tag Packet
	b1 = 0x40000000 |  (hbp          & 0xffff);
	b2 = 0x8000c400 | ((hbp-- >> 16) & 0xf);
	j = fwrite (&b1, sizeof(qb), 1, streamt);
	j = fwrite (&b2, sizeof(qb), 1, streamt);

// Incrementing Lost Event Tally Tag Packet - Type 7 (GIM) & NonFunctional as a Loss Tally
	let1 = 0x40000000 |  (lost          & 0xffff);
	let2 = 0x8000bc00 | ((lost++ >> 16) & 0xf);
	j = fwrite (&let1, sizeof(qb), 1, streamt);
	j = fwrite (&let2, sizeof(qb), 1, streamt);

// Packets to Step through ax Field
	ax = 0; bx = 0; xe = 1;	ay = 0; by = 0; prompt = 1; tof = 0; 
	for (ax=0; ax <= 39; ax++) {	
	  ew1 = ax | ((ay&0x7f)<<8) | (( xe    &7)<<16) | (((xe>>6)&1)<<6) | ((ae&0x3f)<<19) | (((ae>>6)&1)<<15) | (((ae>>7)&1)<<7) | (( tof    &0x7)<<25) | (((tof>>6)&0x1)<<28) | (((tof>>8)&0x1)<<29);
	  ew2 = bx | ((by&0x7f)<<8) | (((xe>>3)&7)<<16) | (((xe>>7)&1)<<6) | ((be&0x3f)<<19) | (((be>>6)&1)<<15) | (((be>>7)&1)<<7) | (((tof>>3)&0x7)<<25) | (((tof>>7)&0x1)<<28) | ((prompt&1)<<30) | (1<<31);
	  j = fwrite (&ew1, sizeof(qb), 1, streamt);
	  j = fwrite (&ew2, sizeof(qb), 1, streamt);
	  i1 = i1 + 1;
	 }

// Incrementing Elapased Time Tag Packet
	e1 = 0x40000000 |  (ms          & 0xffff);
	e2 = 0x80008000 | ((ms++ >> 16) & 0x3fff);
	j = fwrite (&e1, sizeof(qb), 1, streamt);
	j = fwrite (&e2, sizeof(qb), 1, streamt);

// Decrementing Horizontal Bed Position Tag Packet
	b1 = 0x40000000 |  (hbp          & 0xffff);
	b2 = 0x8000c400 | ((hbp-- >> 16) & 0xf);
	j = fwrite (&b1, sizeof(qb), 1, streamt);
	j = fwrite (&b2, sizeof(qb), 1, streamt);

// Incrementing Lost Event Tally Tag Packet - Type 7 (GIM) & NonFunctional as a Loss Tally
	let1 = 0x40000000 |  (lost          & 0xffff);
	let2 = 0x8000bc00 | ((lost++ >> 16) & 0xf);
	j = fwrite (&let1, sizeof(qb), 1, streamt);
	j = fwrite (&let2, sizeof(qb), 1, streamt);

// Packets to Step through bx Field
	ax = 0; bx = 0; xe = 1;	ay = 0; by = 0; ae = 0; be = 0; prompt = 1; tof = 0; 
	for (bx=0; bx <= 39; bx++) {	
	  ew1 = ax | ((ay&0x7f)<<8) | (( xe    &7)<<16) | (((xe>>6)&1)<<6) | ((ae&0x3f)<<19) | (((ae>>6)&1)<<15) | (((ae>>7)&1)<<7) | (( tof    &0x7)<<25) | (((tof>>6)&0x1)<<28) | (((tof>>8)&0x1)<<29);
	  ew2 = bx | ((by&0x7f)<<8) | (((xe>>3)&7)<<16) | (((xe>>7)&1)<<6) | ((be&0x3f)<<19) | (((be>>6)&1)<<15) | (((be>>7)&1)<<7) | (((tof>>3)&0x7)<<25) | (((tof>>7)&0x1)<<28) | ((prompt&1)<<30) | (1<<31);
	  j = fwrite (&ew1, sizeof(qb), 1, streamt);
	  j = fwrite (&ew2, sizeof(qb), 1, streamt);
	  i1 = i1 + 1;
	 }

// Incrementing Elapased Time Tag Packet
	e1 = 0x40000000 |  (ms          & 0xffff);
	e2 = 0x80008000 | ((ms++ >> 16) & 0x3fff);
	j = fwrite (&e1, sizeof(qb), 1, streamt);
	j = fwrite (&e2, sizeof(qb), 1, streamt);

// Decrementing Horizontal Bed Position Tag Packet
	b1 = 0x40000000 |  (hbp          & 0xffff);
	b2 = 0x8000c400 | ((hbp-- >> 16) & 0xf);
	j = fwrite (&b1, sizeof(qb), 1, streamt);
	j = fwrite (&b2, sizeof(qb), 1, streamt);

// Incrementing Lost Event Tally Tag Packet - Type 7 (GIM) & NonFunctional as a Loss Tally
	let1 = 0x40000000 |  (lost          & 0xffff);
	let2 = 0x8000bc00 | ((lost++ >> 16) & 0xf);
	j = fwrite (&let1, sizeof(qb), 1, streamt);
	j = fwrite (&let2, sizeof(qb), 1, streamt);

// Packets to Step through xe Field
	ax = 0; bx = 0; xe = 1;	ay = 0; by = 0; ae = 0; be = 0; prompt = 1; tof = 0; 
	for (xe=1; xe <= 133; xe++) {	
	  ew1 = ax | ((ay&0x7f)<<8) | (( xe    &7)<<16) | (((xe>>6)&1)<<6) | ((ae&0x3f)<<19) | (((ae>>6)&1)<<15) | (((ae>>7)&1)<<7) | (( tof    &0x7)<<25) | (((tof>>6)&0x1)<<28) | (((tof>>8)&0x1)<<29);
	  ew2 = bx | ((by&0x7f)<<8) | (((xe>>3)&7)<<16) | (((xe>>7)&1)<<6) | ((be&0x3f)<<19) | (((be>>6)&1)<<15) | (((be>>7)&1)<<7) | (((tof>>3)&0x7)<<25) | (((tof>>7)&0x1)<<28) | ((prompt&1)<<30) | (1<<31);
	  j = fwrite (&ew1, sizeof(qb), 1, streamt);
	  j = fwrite (&ew2, sizeof(qb), 1, streamt);
	  i1 = i1 + 1;
	 }

// Incrementing Elapased Time Tag Packet
	e1 = 0x40000000 |  (ms          & 0xffff);
	e2 = 0x80008000 | ((ms++ >> 16) & 0x3fff);
	j = fwrite (&e1, sizeof(qb), 1, streamt);
	j = fwrite (&e2, sizeof(qb), 1, streamt);

// Decrementing Horizontal Bed Position Tag Packet
	b1 = 0x40000000 |  (hbp          & 0xffff);
	b2 = 0x8000c400 | ((hbp-- >> 16) & 0xf);
	j = fwrite (&b1, sizeof(qb), 1, streamt);
	j = fwrite (&b2, sizeof(qb), 1, streamt);

// Incrementing Lost Event Tally Tag Packet - Type 7 (GIM) & NonFunctional as a Loss Tally
	let1 = 0x40000000 |  (lost          & 0xffff);
	let2 = 0x8000bc00 | ((lost++ >> 16) & 0xf);
	j = fwrite (&let1, sizeof(qb), 1, streamt);
	j = fwrite (&let2, sizeof(qb), 1, streamt);

// Packets to Step through ay Field
	ax = 0; bx = 0; xe = 1;	ay = 0; by = 0; ae = 0; be = 0; prompt = 1; tof = 0; 
	for (ay=0; ay <= 79; ay++) {	
	  ew1 = ax | ((ay&0x7f)<<8) | (( xe    &7)<<16) | (((xe>>6)&1)<<6) | ((ae&0x3f)<<19) | (((ae>>6)&1)<<15) | (((ae>>7)&1)<<7) | (( tof    &0x7)<<25) | (((tof>>6)&0x1)<<28) | (((tof>>8)&0x1)<<29);
	  ew2 = bx | ((by&0x7f)<<8) | (((xe>>3)&7)<<16) | (((xe>>7)&1)<<6) | ((be&0x3f)<<19) | (((be>>6)&1)<<15) | (((be>>7)&1)<<7) | (((tof>>3)&0x7)<<25) | (((tof>>7)&0x1)<<28) | ((prompt&1)<<30) | (1<<31);
	  j = fwrite (&ew1, sizeof(qb), 1, streamt);
	  j = fwrite (&ew2, sizeof(qb), 1, streamt);
	  i1 = i1 + 1;
	 }

// Incrementing Elapased Time Tag Packet
	e1 = 0x40000000 |  (ms          & 0xffff);
	e2 = 0x80008000 | ((ms++ >> 16) & 0x3fff);
	j = fwrite (&e1, sizeof(qb), 1, streamt);
	j = fwrite (&e2, sizeof(qb), 1, streamt);

// Decrementing Horizontal Bed Position Tag Packet
	b1 = 0x40000000 |  (hbp          & 0xffff);
	b2 = 0x8000c400 | ((hbp-- >> 16) & 0xf);
	j = fwrite (&b1, sizeof(qb), 1, streamt);
	j = fwrite (&b2, sizeof(qb), 1, streamt);

// Incrementing Lost Event Tally Tag Packet - Type 7 (GIM) & NonFunctional as a Loss Tally
	let1 = 0x40000000 |  (lost          & 0xffff);
	let2 = 0x8000bc00 | ((lost++ >> 16) & 0xf);
	j = fwrite (&let1, sizeof(qb), 1, streamt);
	j = fwrite (&let2, sizeof(qb), 1, streamt);

// Packets to Step through by Field
	ax = 0; bx = 0; xe = 1;	ay = 0; by = 0; ae = 0; be = 0; prompt = 1; tof = 0; 
	for (by=0; by <= 79; by++) {	
	  ew1 = ax | ((ay&0x7f)<<8) | (( xe    &7)<<16) | (((xe>>6)&1)<<6) | ((ae&0x3f)<<19) | (((ae>>6)&1)<<15) | (((ae>>7)&1)<<7) | (( tof    &0x7)<<25) | (((tof>>6)&0x1)<<28) | (((tof>>8)&0x1)<<29);
	  ew2 = bx | ((by&0x7f)<<8) | (((xe>>3)&7)<<16) | (((xe>>7)&1)<<6) | ((be&0x3f)<<19) | (((be>>6)&1)<<15) | (((be>>7)&1)<<7) | (((tof>>3)&0x7)<<25) | (((tof>>7)&0x1)<<28) | ((prompt&1)<<30) | (1<<31);
	  j = fwrite (&ew1, sizeof(qb), 1, streamt);
	  j = fwrite (&ew2, sizeof(qb), 1, streamt);
	  i1 = i1 + 1;
	 }

// Incrementing Elapased Time Tag Packet
	e1 = 0x40000000 |  (ms          & 0xffff);
	e2 = 0x80008000 | ((ms++ >> 16) & 0x3fff);
	j = fwrite (&e1, sizeof(qb), 1, streamt);
	j = fwrite (&e2, sizeof(qb), 1, streamt);

// Decrementing Horizontal Bed Position Tag Packet
	b1 = 0x40000000 |  (hbp          & 0xffff);
	b2 = 0x8000c400 | ((hbp-- >> 16) & 0xf);
	j = fwrite (&b1, sizeof(qb), 1, streamt);
	j = fwrite (&b2, sizeof(qb), 1, streamt);

// Incrementing Lost Event Tally Tag Packet - Type 7 (GIM) & NonFunctional as a Loss Tally
	let1 = 0x40000000 |  (lost          & 0xffff);
	let2 = 0x8000bc00 | ((lost++ >> 16) & 0xf);
	j = fwrite (&let1, sizeof(qb), 1, streamt);
	j = fwrite (&let2, sizeof(qb), 1, streamt);

// Packets to Step through ae Field
	ax = 0; bx = 0; xe = 1;	ay = 0; by = 0; ae = 0; be = 0; prompt = 1; tof = 0; 
	for (ae=0; ae <= 255; ae++) {	
	  ew1 = ax | ((ay&0x7f)<<8) | (( xe    &7)<<16) | (((xe>>6)&1)<<6) | ((ae&0x3f)<<19) | (((ae>>6)&1)<<15) | (((ae>>7)&1)<<7) | (( tof    &0x7)<<25) | (((tof>>6)&0x1)<<28) | (((tof>>8)&0x1)<<29);
	  ew2 = bx | ((by&0x7f)<<8) | (((xe>>3)&7)<<16) | (((xe>>7)&1)<<6) | ((be&0x3f)<<19) | (((be>>6)&1)<<15) | (((be>>7)&1)<<7) | (((tof>>3)&0x7)<<25) | (((tof>>7)&0x1)<<28) | ((prompt&1)<<30) | (1<<31);
	  j = fwrite (&ew1, sizeof(qb), 1, streamt);
	  j = fwrite (&ew2, sizeof(qb), 1, streamt);
	  i1 = i1 + 1;
	 }


// Incrementing Elapased Time Tag Packet
	e1 = 0x40000000 |  (ms          & 0xffff);
	e2 = 0x80008000 | ((ms++ >> 16) & 0x3fff);
	j = fwrite (&e1, sizeof(qb), 1, streamt);
	j = fwrite (&e2, sizeof(qb), 1, streamt);

// Decrementing Horizontal Bed Position Tag Packet
	b1 = 0x40000000 |  (hbp          & 0xffff);
	b2 = 0x8000c400 | ((hbp-- >> 16) & 0xf);
	j = fwrite (&b1, sizeof(qb), 1, streamt);
	j = fwrite (&b2, sizeof(qb), 1, streamt);

// Incrementing Lost Event Tally Tag Packet - Type 7 (GIM) & NonFunctional as a Loss Tally
	let1 = 0x40000000 |  (lost          & 0xffff);
	let2 = 0x8000bc00 | ((lost++ >> 16) & 0xf);
	j = fwrite (&let1, sizeof(qb), 1, streamt);
	j = fwrite (&let2, sizeof(qb), 1, streamt);

// Packets to Step through be Field
	ax = 0; bx = 0; xe = 1;	ay = 0; by = 0; ae = 0; be = 0; prompt = 1; tof = 0; 
	for (be=0; be <= 255; be++) {	
	  ew1 = ax | ((ay&0x7f)<<8) | (( xe    &7)<<16) | (((xe>>6)&1)<<6) | ((ae&0x3f)<<19) | (((ae>>6)&1)<<15) | (((ae>>7)&1)<<7) | (( tof    &0x7)<<25) | (((tof>>6)&0x1)<<28) | (((tof>>8)&0x1)<<29);
	  ew2 = bx | ((by&0x7f)<<8) | (((xe>>3)&7)<<16) | (((xe>>7)&1)<<6) | ((be&0x3f)<<19) | (((be>>6)&1)<<15) | (((be>>7)&1)<<7) | (((tof>>3)&0x7)<<25) | (((tof>>7)&0x1)<<28) | ((prompt&1)<<30) | (1<<31);
	  j = fwrite (&ew1, sizeof(qb), 1, streamt);
	  j = fwrite (&ew2, sizeof(qb), 1, streamt);
	  i1 = i1 + 1;
	 }

// Incrementing Elapased Time Tag Packet
	e1 = 0x40000000 |  (ms          & 0xffff);
	e2 = 0x80008000 | ((ms++ >> 16) & 0x3fff);
	j = fwrite (&e1, sizeof(qb), 1, streamt);
	j = fwrite (&e2, sizeof(qb), 1, streamt);

// Decrementing Horizontal Bed Position Tag Packet
	b1 = 0x40000000 |  (hbp          & 0xffff);
	b2 = 0x8000c400 | ((hbp-- >> 16) & 0xf);
	j = fwrite (&b1, sizeof(qb), 1, streamt);
	j = fwrite (&b2, sizeof(qb), 1, streamt);

// Incrementing Lost Event Tally Tag Packet - Type 7 (GIM) & NonFunctional as a Loss Tally
	let1 = 0x40000000 |  (lost          & 0xffff);
	let2 = 0x8000bc00 | ((lost++ >> 16) & 0xf);
	j = fwrite (&let1, sizeof(qb), 1, streamt);
	j = fwrite (&let2, sizeof(qb), 1, streamt);

// Packets to Step through tof Field
	ax = 0; bx = 0; xe = 1;	ay = 0; by = 0; ae = 0; be = 0; prompt = 1; tof = 0; 
	for (tof=-256; tof <= 255; tof++) {	
	  ew1 = ax | ((ay&0x7f)<<8) | (( xe    &7)<<16) | (((xe>>6)&1)<<6) | ((ae&0x3f)<<19) | (((ae>>6)&1)<<15) | (((ae>>7)&1)<<7) | (( tof    &0x7)<<25) | (((tof>>6)&0x1)<<28) | (((tof>>8)&0x1)<<29);
	  ew2 = bx | ((by&0x7f)<<8) | (((xe>>3)&7)<<16) | (((xe>>7)&1)<<6) | ((be&0x3f)<<19) | (((be>>6)&1)<<15) | (((be>>7)&1)<<7) | (((tof>>3)&0x7)<<25) | (((tof>>7)&0x1)<<28) | ((prompt&1)<<30) | (1<<31);
	  j = fwrite (&ew1, sizeof(qb), 1, streamt);
	  j = fwrite (&ew2, sizeof(qb), 1, streamt);
	  i1 = i1 + 1;
	 }

// Incrementing Elapased Time Tag Packet
	e1 = 0x40000000 |  (ms          & 0xffff);
	e2 = 0x80008000 | ((ms++ >> 16) & 0x3fff);
	j = fwrite (&e1, sizeof(qb), 1, streamt);
	j = fwrite (&e2, sizeof(qb), 1, streamt);

// Decrementing Horizontal Bed Position Tag Packet
	b1 = 0x40000000 |  (hbp          & 0xffff);
	b2 = 0x8000c400 | ((hbp-- >> 16) & 0xf);
	j = fwrite (&b1, sizeof(qb), 1, streamt);
	j = fwrite (&b2, sizeof(qb), 1, streamt);

// Incrementing Lost Event Tally Tag Packet - Type 7 (GIM) & NonFunctional as a Loss Tally
	let1 = 0x40000000 |  (lost          & 0xffff);
	let2 = 0x8000bc00 | ((lost++ >> 16) & 0xf);
	j = fwrite (&let1, sizeof(qb), 1, streamt);
	j = fwrite (&let2, sizeof(qb), 1, streamt);

// Example of One Delayed & One Prompt Events
	ax = 0; bx = 0; xe = 1;	ay = 0; by = 0; prompt = 1; tof = 0; 
	for (prompt=0; prompt <= 1; prompt++) {	
	  ew1 = ax | ((ay&0x7f)<<8) | (( xe    &7)<<16) | (((xe>>6)&1)<<6) | ((ae&0x3f)<<19) | (((ae>>6)&1)<<15) | (((ae>>7)&1)<<7) | (( tof    &0x7)<<25) | (((tof>>6)&0x1)<<28) | (((tof>>8)&0x1)<<29);
	  ew2 = bx | ((by&0x7f)<<8) | (((xe>>3)&7)<<16) | (((xe>>7)&1)<<6) | ((be&0x3f)<<19) | (((be>>6)&1)<<15) | (((be>>7)&1)<<7) | (((tof>>3)&0x7)<<25) | (((tof>>7)&0x1)<<28) | ((prompt&1)<<30) | (1<<31);
	  j = fwrite (&ew1, sizeof(qb), 1, streamt);
	  j = fwrite (&ew2, sizeof(qb), 1, streamt);
	  i1 = i1 + 1;
	 }

// Maximum Value for Elapased Time Tag Packet
	ms = 0x1fffffff; // all bits in 29-bit field set to one
	e1 = 0x40000000 |  (ms          & 0xffff);
	e2 = 0x80008000 | ((ms   >> 16) & 0x3fff);
	j = fwrite (&e1, sizeof(qb), 1, streamt);
	j = fwrite (&e2, sizeof(qb), 1, streamt);

// Minimum Value (most negative) Horizontal Bed Position Tag Packet
	hbp = 0x80000; 
	b1 = 0x40000000 |  (hbp          & 0xffff);
	b2 = 0x8000c400 | ((hbp   >> 16) & 0xf);
	j = fwrite (&b1, sizeof(qb), 1, streamt);
	j = fwrite (&b2, sizeof(qb), 1, streamt);

// Maximum Value Lost Event Tally Tag Packet - Type 7 (GIM) & NonFunctional as a Loss Tally
	lost = 0xfffff; // all bits in 20-bit field set to one
	let1 = 0x40000000 |  (lost          & 0xffff);
	let2 = 0x8000bc00 | ((lost   >> 16) & 0xf);
	j = fwrite (&let1, sizeof(qb), 1, streamt);
	j = fwrite (&let2, sizeof(qb), 1, streamt);

	printf (" number of 64-bit packets output: %I64d file size: %I64x\n",i1,8*i1);
	fclose (streamt);
	exit(0);
}
